'use strict';

parcel_services.controllers.module('edit-modal', ['xhr', gx.source + '/libs/info_messages'], function () {
	return {
		vue: true,
		name: 'gx-edit-modal',
		template: '#edit-modal',
		parent: 'gx-parcel-services-overview',
		props: ['languages'],
		data: function data() {
			return {
				lang: {
					title: jse.core.lang.translate('edit_modal_title', 'parcel_services'),
					close: jse.core.lang.translate('cancel', 'buttons'),
					confirm: jse.core.lang.translate('save', 'buttons'),
					labels: {
						name: jse.core.lang.translate('label_name', 'parcel_services'),
						isDefault: jse.core.lang.translate('label_set_as_default', 'parcel_services'),
						comment: jse.core.lang.translate('label_comment', 'parcel_services'),
						url: jse.core.lang.translate('label_url', 'parcel_services'),
						placeholder: jse.core.lang.translate('label_tracking_number_placeholder', 'parcel_services')
					}
				},
				validFormData: {
					name: true
				},
				selectedLanguage: '',
				details: {
					name: '',
					isDefault: false,
					descriptions: []
				}
			};
		},
		methods: {
			confirm: function confirm() {
				var _this = this;

				if (this.checkFormData() === false) {
					return;
				}

				jse.libs.xhr.put({
					url: './api/parcel-services',
					data: this.details
				}).done(function (response) {
					_this.$emit('reload-overview');
				}).fail(function (response) {
					console.error('Could not update parcel service.', response);
					jse.libs.info_messages.addError(jse.core.lang.translate('error_could_not_update_parcel_service', 'parcel_services'));
				});
				$('.edit-modal.modal').modal('hide');
			},
			checkFormData: function checkFormData() {
				this.validFormData.name = this.details.name.trim().length !== 0;

				return this.validFormData.name;
			},
			changeLanguage: function changeLanguage(languageId) {
				this.selectedLanguage = languageId;
				if (this.details.descriptions[languageId] === undefined) {
					this.details.descriptions[languageId] = {
						languageId: languageId,
						url: '',
						comment: ''
					};
				}
			},
			openModal: function openModal(details) {
				this.selectedLanguage = this.languages[0].id;
				this.details = {
					id: details.id,
					name: details.name,
					isDefault: details.isDefault,
					descriptions: {}
				};
				for (var i in details.descriptions) {
					var languageId = details.descriptions[i].languageId;
					this.details.descriptions[languageId] = details.descriptions[i];
				}

				if (this.$children[0] !== undefined) {
					this.$children[0].input = this.details.isDefault;
				}
				gx.widgets.init($('.edit-modal.modal'));
				$('.edit-modal.modal').modal('show');
			}
		},
		init: function init(done) {
			return done();
		}
	};
});
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
